//
// Spline Wave.js
//

var Vec3D_len = function() {
    if( arguments.length == 1)
        return Math.sqrt( arguments[0].x*arguments[0].x + arguments[0].y*arguments[0].y + arguments[0].z*arguments[0].z );
    var p = arguments[1].sub(arguments[0]);
    return Math.sqrt( p.x*p.x + p.y*p.y + p.z*p.z );
}

var Vec3D_normalize = function() {
        var l = arguments[0].norm();
        if( l != 0 ) 
            return arguments[0].multiply(1/l);
        return arguments[0];
}

var spl_hol = [];
var spl_list = [];

// static value, pre-calculated;
var radian_p = 180/Math.PI;

function buildUI(obj){
	obj.addParameterLink("guide spline", true);

	obj.addParameterSelector("wave type", [ "sin", "cos" ], true, true );
	obj.addParameterSelector("wave direction", [ "x", "z" ], true, true );
	obj.addParameterFloat("wave detail", 0.25, 0.02, 0.5, true, true);
    obj.addParameterFloat("wave length", 0.1, 0, 10000, true, true);
    obj.addParameterBool("use path length", 0, 0, 1, true, true);
    obj.addParameterFloat("wave height", 0.1, 0, 10000, true, true);
	obj.addParameterFloat("offset", 0, -100, 100, true, true);
	//obj.addParameterFloat("apprx. angle", 5.0, 1, 90, true, true);

	obj.setParameter("name", "Spline Wave");
}


function buildObject(obj){

	var guide = obj.getParameter("guide spline");

	if (!guide || guide.family() != SPLINEFAMILY) {
		return;
	}

	var guideMat = guide.obj2WorldMatrix();
	var guideCore = guide.modCore();

	//obj.setParameter("angle", obj.getParameter("apprx. angle"), false);

	var core = obj.core();

	var type = obj.getParameter("wave type");
	var direction = obj.getParameter("wave direction");

	if (direction == 0) { //x
		if (type == 0) {
			var func = function( step, offset, height ) { return new Vec3D( Math.sin( Math.PI * step + Math.PI * offset ) * height, 0, 0) };
		} else if (type == 1) {
			var func = function( step, offset, height ) { return new Vec3D( Math.cos( Math.PI * step + Math.PI * offset ) * height, 0, 0) };
		}
	} else if (direction == 1) { // z
		if (type == 0) {
			var func = function( step, offset, height ) { return new Vec3D( 0, 0, Math.sin( Math.PI * step + Math.PI * offset ) * height) };
		} else if (type == 1) {
			var func = function( step, offset, height ) { return new Vec3D( 0, 0, Math.cos( Math.PI * step + Math.PI * offset ) * height) };
		}
	}

	var usePathLength = obj.getParameter("use path length");
	var length = obj.getParameter("wave length");
	var height = obj.getParameter("wave height");
	var offset = obj.getParameter("offset");

	if (length == 0) return;

	var pathCount = guideCore.pathCount();
	var p_dir = new Vec3D();

	var detail = obj.getParameter("wave detail");

	for (var i = 0;i < pathCount;i++) {
		//

		if (usePathLength) {

			var cache = guideCore.cache(i);

			for (var j = 0;j < cache.length;j++) {

				if (j != cache.length - 1) {

					var segment = Math.floor( 1 / detail );

					for (var k = 0;k < segment;k++) {

						var vec1 = cache[j];
						var vec2 = cache[j+1];

						var vec = vec1.add( vec2.sub( vec1 ).multiply( 1 * detail * k));

						if (j == 0) {
							var dir_vec = cache[j+1];
							p_dir = dir_vec.sub(vec);
							p_dir = Vec3D_normalize( p_dir );
						} else {
							var dir1_vec = cache[j-1];
							var dir2_vec = cache[j+1];

							p_dir = dir2_vec.sub(dir1_vec);
							p_dir = Vec3D_normalize( p_dir );
						}

						vec = guideMat.multiply( vec );

						var phi = Math.atan2( p_dir.x, p_dir.z ) * radian_p;
						var theta = Math.acos( p_dir.y ) * radian_p;

						var rotMat = new Mat4D( ROTATE_HPB, phi, theta, 0 );
						rotMat = guideMat.multiply( rotMat );

						var p = func( j + (k * detail), offset, height );

						p = vec.add( rotMat.multiply( p ) );

						if (j == 0 && k == 0) {
							core.move( p );
						} else {
							core.line( p );
						}
					}

				} else　{

					var vec = cache[j];

					var dir1_vec = cache[j-1];
					p_dir = vec.sub( dir_vec );
					p_dir = Vec3D_normalize( p_dir );

					vec = guideMat.multiply( vec );

					var phi = Math.atan2( p_dir.x, p_dir.z) * radian_p;
					var theta = Math.acos( p_dir.y ) * radian_p;

					var rotMat = new Mat4D( ROTATE_HPB, phi, theta, 0);
					rotMat = guideMat.multiply( rotMat );

					var p = func( j, offset, height);
					p = vec.add( rotMat.multiply( p ) );

					//print( p.x.toFixed(2) + ', ' + p.y.toFixed(2) + ', ' + p.z.toFixed(2) );

					core.line( p );
				}
			}


		} else {
			spl_hol = guideCore.cache(i);
			spl_list = [];


			var pathLength = calcSplineLength(spl_hol, spl_list);
			var segment = Math.floor( pathLength / length / detail );

			//print( 'pathLength: ' + pathLength + ', segment: ' + segment);

			for (var j = 0;j <= segment;j++) {

				var vec = pointFromPercentage(spl_hol, spl_list, j / segment);

				if (j == 0) {
					var dir_vec = pointFromPercentage(spl_hol, spl_list, (j+1)/segment);
					p_dir = dir_vec.sub(vec);
					p_dir = Vec3D_normalize( p_dir );
				} else if (j == segment) {
					var dir_vec = pointFromPercentage(spl_hol, spl_list, (j-1)/segment);
					p_dir = vec.sub(dir_vec);
					p_dir = Vec3D_normalize( p_dir );
				} else {
					var dir1_vec = pointFromPercentage(spl_hol, spl_list, (j-1)/segment);
					var dir2_vec = pointFromPercentage(spl_hol, spl_list, (j+1)/segment);

					p_dir = dir2_vec.sub(dir1_vec);
					p_dir = Vec3D_normalize( p_dir );
				}

				vec = guideMat.multiply( vec );

				//
				var phi = Math.atan2( p_dir.x, p_dir.z ) * radian_p;
				var theta = Math.acos( p_dir.y ) * radian_p;

				var rotMat = new Mat4D( ROTATE_HPB, phi, theta, 0);
				rotMat = guideMat.multiply( rotMat );

				var p = func( j * detail, offset, height ); 

				p = vec.add( rotMat.multiply( p ) );

				//print( p.x.toFixed(2) + ', ' + p.y.toFixed(2) + ', ' + p.z.toFixed(2) );
				if (j == 0) {
					core.move( p );
				} else {
					core.line( p );
				}

			}

		}

	}



}

// these functions from Todd's Loft.js script.
// thank you for sharing, Todd. :D
function calcSplineLength(points,lst) {
    if (!points) {
        lst = [];
        return accum;
    }
	var l = points.length;
	var i;
	var accum = 0;
	lst[0] = 0;
	for(i=0;i<l-1;i++) {
		var p = points[i+1].sub(points[i]);
		accum = accum + Math.sqrt( p.x * p.x + p.y * p.y + p.z * p.z);
		lst[i+1] = accum;
	}
	for(i=0;i<l;i++) {
		lst[i] = lst[i]/accum;
	}
	return accum;
}

// percent must be >= 0 and <= 1
function pointFromPercentage(path,lst,percent) {
    if (!path || path.length < 1) return new Vec3D();
    
	while( percent < 0) percent += 1;
	while( percent > 1) percent -= 1;
	var i,hi = (path)? path.length-1 : 0;
	var lo = 0;
	var d = percent;
	while(hi-lo > 1) {
		i = Math.floor((hi+lo)/2);
		if( percent <= lst[i] ) {
			hi = i;
			continue;
		}
		if( percent > lst[i] ) {
			lo = i;
		}
	}
	i = hi;
			
	var p1 = path[i-1];
	var p2 = path[i];
	// convert d into a percentage between the two points
	d = (d - lst[i-1])/(lst[i] - lst[i-1]);
	p1 = p1.multiply(1-d).add(p2.multiply(d));
	return p1;
}

